'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - Ultima Printers                         **/
'/**                                                                       **/
'/**  MODULE NAME  : Info.vb                                               **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Partial Public Class Main

#Region "=== Local methods ==="

    Private Sub InitInfoTab()
    End Sub

    Private Sub OutputBurstMessage(ByVal MsgBox As TextBox, ByVal asciiArray As String)
        Dim c As Char
        For i = 0 To Len(asciiArray) - 1
            c = Mid(asciiArray, i + 1, 1)
            If c = Chr(13) Then
                MsgBox.AppendText(Environment.NewLine)
            Else
                MsgBox.AppendText(c.ToString())
            End If
        Next

        MsgBox.AppendText(Environment.NewLine)
        MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub ClearMsgBoxButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ClearMsgBoxButton.Click
        InfoMsgBox.Clear()
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printer Status ==="

    Private Sub PrinterStatusButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterStatusButton.Click
        Select Case SDK.ID_PrinterStatus(hSession)
            Case SDK.PrinterStatus.Ready
                InfoMsgBox.AppendText("Printer is READY" + Environment.NewLine)
            Case SDK.PrinterStatus.Offline
                InfoMsgBox.AppendText("Printer is OFFLINE" + Environment.NewLine)
            Case SDK.PrinterStatus.Error
                InfoMsgBox.AppendText("Printer is ERROR" + Environment.NewLine)
            Case Else
                InfoMsgBox.AppendText("Unknown Printer Status" + Environment.NewLine)
        End Select
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printer Info ==="

    Private Sub PrinterInfoButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterInfoButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim PrinterInfo As New SDK.UltimaInfo
        Dim SDKReturn As SDK.Return = SDK.ID_PrinterInfo(hSession, PrinterInfo)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("PrinterInfo", SDKReturn)
            Return
        End If

        InfoMsgBox.AppendText("FirmwareVersion: " + PrinterInfo.firmware_version + Environment.NewLine)
        InfoMsgBox.AppendText("PrinterSerial: " + PrinterInfo.printer_serial + Environment.NewLine)
        InfoMsgBox.AppendText("ModelName: " + PrinterInfo.model_name + Environment.NewLine)
        InfoMsgBox.AppendText("PrinterPartnerCode: " + PrinterInfo.printer_partner_code.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CapabilityFlags: " + PrinterInfo.capability_flags.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("Manufacturer: " + PrinterInfo.manufacturer.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("TransferTargetTemp: " + PrinterInfo.transfer_target_temperature.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("TransferActualTemp: " + PrinterInfo.transfer_actual_temperature.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("TotalCards: " + PrinterInfo.total_cards.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("TotalPanels: " + PrinterInfo.total_panels.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CardsOnPrinthead: " + PrinterInfo.cards_on_printhead.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("PanelsOnPrinthead: " + PrinterInfo.panels_on_printhead.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("CardsLowLevel: " + PrinterInfo.cards_low.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ColourName: " + PrinterInfo.colour_name + Environment.NewLine)
        InfoMsgBox.AppendText("ColourTotalPrints: " + PrinterInfo.colour_total_prints.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ColourPrintsRemaining: " + PrinterInfo.colour_prints_remaining.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ColourPartnerCode: " + PrinterInfo.colour_partner_code.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("TransferName: " + PrinterInfo.transfer_name + Environment.NewLine)
        InfoMsgBox.AppendText("TransferTotalPrints: " + PrinterInfo.transfer_total_prints.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("TransferPrintsRemaining: " + PrinterInfo.transfer_prints_remaining.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("TransferPartnerCode: " + PrinterInfo.transfer_partner_code.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("ErrorCode: " + PrinterInfo.error_code.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("ErrorContext: " + PrinterInfo.error_context.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("CardsBetweenPrompts: " + PrinterInfo.cards_between_prompts.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CleaningOverdue: " + PrinterInfo.cleaning_overdue.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CardsSinceClean: " + PrinterInfo.cards_since_clean.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("PanelsSinceClean: " + PrinterInfo.panels_since_clean.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CleaningCycles: " + PrinterInfo.cleaning_cycles.ToString() + Environment.NewLine)

        InfoMsgBox.AppendText("LaminateActualTemperature: " + PrinterInfo.laminate_actual_temperature.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("LaminateTargetTemperature: " + PrinterInfo.laminate_target_temperature.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("LaminateType: " + PrinterInfo.laminate_type.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText("CardSpeed: " + PrinterInfo.card_speed.ToString() + Environment.NewLine)
        InfoMsgBox.AppendText(Environment.NewLine)

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== SDK Version ==="

    Private Sub SDKVersionButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles SDKVersionButton.Click
        Dim SDKVersion As New SDK.SDKVersion
        Dim SDKReturn As SDK.Return = SDK.ID_SDKVersion(hSession, SDKVersion)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("SDKVersion", SDKReturn)
        Else
            InfoMsgBox.AppendText("Version: " + SDKVersion.Major.ToString() _
                                  + "." + SDKVersion.Minor.ToString() _
                                  + "." + SDKVersion.Build.ToString() _
                                  + "." + SDKVersion.Private.ToString() _
                                  + Environment.NewLine)
            InfoMsgBox.AppendText(Environment.NewLine)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Connection Type === "

    Private Sub ConnectionTypeButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ConnectionTypeButton.Click
        Dim msg As String
        Select Case SDK.ID_ConnectionType(hSession)
            Case SDK.ConnectionType.USB
                msg = "USB"
            Case SDK.ConnectionType.Ethernet
                msg = "Ethernet"
            Case SDK.ConnectionType.File
                msg = "File"
            Case Else
                msg = "Unknown"
        End Select
        InfoMsgBox.AppendText("Connection Type: " + msg + Environment.NewLine)
        InfoMsgBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printer Type ==="

    Private Sub PrinterTypeButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterTypeButton.Click
        InfoMsgBox.AppendText("Printer Type - ")
        Select SDK.ID_PrinterType(hSession)
            Case SDK.PrinterType.Rio
                InfoMsgBox.AppendText("RioTango" + Environment.NewLine)
            Case SDK.PrinterType.AOTA
                InfoMsgBox.AppendText("AOTA" + Environment.NewLine)
            Case SDK.PrinterType.Enduro
                InfoMsgBox.AppendText("Enduro Family" + Environment.NewLine)
            Case SDK.PrinterType.Ultima
                InfoMsgBox.AppendText("Ultima" + Environment.NewLine)
            Case SDK.PrinterType.RioPro360
                InfoMsgBox.AppendText("Rio Pro 360 Family" + Environment.NewLine)
            Case Else
                InfoMsgBox.AppendText("UNKNOWN" + Environment.NewLine)
        End Select
        InfoMsgBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printer Model ==="

    Private Sub PrinterModelButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrinterModelButton.Click

        Dim msg As String
        Dim model As SDK.Model = SDK.ID_PrinterModel(hSession)
        If model.HasFlag(SDK.Model.Ultima) Then
            msg = "Ultima"
        Else
            msg = "Unknown"
        End If
        InfoMsgBox.AppendText("Printer - " + msg + Environment.NewLine)

        InfoMsgBox.AppendText("Capability:" + Environment.NewLine)
        If model.HasFlag(SDK.Model.Fn_Magnetic) Then
            InfoMsgBox.AppendText("  - Mag Encoding" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Duplex) Then
            InfoMsgBox.AppendText("  - Duplex" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Chip) Then
            InfoMsgBox.AppendText("  - Chip Encoding" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Contactless) Then
            InfoMsgBox.AppendText("  - Contactless Encoding" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Ethernet) Then
            InfoMsgBox.AppendText("  - Ethernet" + Environment.NewLine)
        End If

        If model.HasFlag(SDK.Model.Fn_Laminate) Then
            InfoMsgBox.AppendText("  - Laminator" + Environment.NewLine)
        End If

        InfoMsgBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== SDK Bits ==="

    Private Sub SDKBitsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SDKBitsButton.Click
        InfoMsgBox.AppendText(SDK.ID_SDKBits().ToString + " Bit SDK" + Environment.NewLine + Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Temperature ==="

    Private Sub TemperatureButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles TemperatureButton.Click
        Dim status As Boolean = False
        Dim SDKReturn As SDK.Return = SDK.ID_Temperature(hSession, SDK.Temperature.Transfer, status)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("Temperature", SDKReturn)
        Else
            Dim msg As String
            If status Then
                msg = "Ready"
            Else
                msg = "Preheat"
            End If
            InfoMsgBox.AppendText("Transfer Temperature: " + msg + Environment.NewLine + Environment.NewLine)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Last Message ==="

    Private Sub LastMessageButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles LastMessageButton.Click
        Dim Temp As New StringBuilder
        Dim SDKReturn As SDK.Return = SDK.ID_LastMessage(hSession, Temp)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("GetLastMessage", SDKReturn)
        Else
            OutputBurstMessage(InfoMsgBox, Temp.ToString())
        End If

    End Sub

#End Region


End Class
